<?php
/*****************************************************
 *** This free template(theme) is TEMPLX.
 *** http://templx.com/
 *** http://l-vip.info/
*****************************************************/

// ----- jquery出力
 function tx_ecqueue_jquery() {
  if(!is_admin()){
   wp_enqueue_script('jquery');
   wp_enqueue_style('style', get_template_directory_uri().'/style.css', array(),NULL,'all');
   wp_enqueue_script('t_script', get_stylesheet_directory_uri().'/js/t_script.js', array(), NULL, false);
  }
 }
 add_action('wp_enqueue_scripts', 'tx_ecqueue_jquery');
// jquery出力

// ----- キーワード検索
 function tx_search_form( $tx_form ) {
  $path=(get_bloginfo('template_directory'). '/images/search-bot.png');
  $tx_form = '<div id="search"><div id="search-in"><form method="get" id="searchform" action="'.home_url( '/' ).'" >
              <label class="screen-reader-text" for="s">' . __('') . '</label>
              <input type="text" value="' . get_search_query() . '" name="s" id="s" />
              <input src="'.$path.'" type="image" formaction="'.home_url( '/' ).'" id="searchsubmit" alt="search" width="30" height="20" class="intersection-img" />
              </form></div></div>';
              return $tx_form;
 }
 add_filter( 'get_search_form', 'tx_search_form' );
// キーワード検索

// ----- ウィジェット領域
 if ( function_exists('register_sidebar') )
  register_sidebar(array(
    'name' => __('共通ウィジェット'),
    'id' => 'one',
    'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget-body">',
    'after_widget' => '</div></aside>',
    'before_title' => '<h2><span>',
    'after_title' => '</span></h2>',
  ));
// ウィジェット領域

// ----- ページ送り
 function tx_navigation() {
   global $wp_rewrite, $wp_query, $paged;
     $paginate_base = get_pagenum_link(1);
       if (($wp_query->max_num_pages) > 1):
         if (strpos($paginate_base, '?') || ! $wp_rewrite->using_permalinks()) {
           $paginate_format = '';
              $paginate_base = add_query_arg('paged', '%#%');
         } else {
           $paginate_format = (substr($paginate_base, -1 ,1) == '/' ? '' : '/') .
           user_trailingslashit('page/%#%/', 'paged');
           $paginate_base .= '%_%';
         }
         $result = paginate_links( array(
                'base' => $paginate_base,
                'format' => $paginate_format,
                'total' => $wp_query->max_num_pages,
                'mid_size' => 5,
                'current' => ($paged ? $paged : 1),
         ));
         echo '<div class="page-numb">'."\n".$result."\n</div>\n";
         endif;
      }
// ページ送り

// ----- 一覧クエリー
 function tx_pre_get_posts_query($query) {
   if($query->is_search) {
     $query->set('post_type', 'post');
   }
   return $query;
 }
 add_filter('pre_get_posts','tx_pre_get_posts_query');
// 一覧クエリー

// ----- その他
  add_theme_support('automatic-feed-links');
  add_theme_support('menus');
  add_theme_support('post-thumbnails', array('post'));
  add_theme_support('post-formats', array('aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'));
  remove_action('wp_head', 'wp_generator');
  remove_action('wp_head', 'print_emoji_detection_script', 7);
  remove_action('admin_print_scripts', 'print_emoji_detection_script');
  remove_action('wp_print_styles', 'print_emoji_styles');
  remove_action('admin_print_styles', 'print_emoji_styles');
  remove_filter('the_content_feed', 'wp_staticize_emoji');
  remove_filter('comment_text_rss', 'wp_staticize_emoji');
  remove_filter('wp_mail', 'wp_staticize_emoji_for_email');

  function tx_remove_version($src){
    if(strpos($src, '?ver='))
      $src = remove_query_arg('ver', $src);
    return $src;
  }
  add_filter('script_loader_src', 'tx_remove_version');
  add_filter('style_loader_src', 'tx_remove_version');

  function tx_admin_footer(){
    echo 'この度は<a href="http://l-vip.info/" target="_blank">L-VIP無料テンプレート</a>をダウンロードして頂きありがとうございます。<br />ルールを守ってご使用ください。';
  }
  add_filter('admin_footer_text', 'tx_admin_footer');

  function tx_add_head (){
    echo '<meta name="generator" content="L-VIP" />';
  }
  add_action ('wp_head','tx_add_head');

  function tx_remove_recent_comments(){
    global $wp_widget_factory;
      remove_action('wp_head', array($wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style'));
  }
  add_action('widgets_init', 'tx_remove_recent_comments');
// その他
?>